#include <iostream>
#include <string>
#include <cstdlib>
#include <cstdio>
#include <algorithm>
#include <map>
#include <set>
#include <vector>
#include <cmath>
#include <cstring>
#include <queue>
#include <deque>
#include <functional>
#include <climits>

#define mp make_pair
#define mt(a, b, c) mp(a, mp(b, c))
#define ABS(a) (((a) > 0) ? (a) : (-(a)))
#define ZERO(x) memset((x), 0, sizeof(x))
#define X first
#define Y second

using namespace std;
typedef long long ll;
typedef unsigned long long ull;
typedef pair<int, int> ii;

const int N = 55; //Max vertices count

struct edge
{
	int to;
	int rev;
	int cap;
	int flow;
	edge(int _to, int _rev, int _cap, int _flow)
	{
		to = _to;
		rev = _rev;
		cap = _cap;
		flow = _flow;
	}
};

vector<edge> e[N];
int s = 0, t = N - 1;

void add_edge(int from, int to, int cap)
{
	edge a = edge(to, e[to].size(), cap, 0);
	edge b = edge(from, e[from].size(), 0, 0);

	e[from].push_back(a);
	e[to].push_back(b);
}

int d[N];

bool bfs()
{
	fill(d, d + N, 1e9);
	d[s] = 0;
	queue<int> q;
	q.push(s);
	while (!q.empty())
	{
		int v = q.front();
		q.pop();
		for (int i = 0; i < e[v].size(); i++)
		{
			int to = e[v][i].to;
			if (d[to] != 1e9) continue;
			if (e[v][i].cap - e[v][i].flow == 0) continue;
			d[to] = d[v] + 1;
			q.push(to);
		}
	}
	return d[t] != 1e9;
}

int pts[N];

int dfs(int v, int push)
{
	if (push == 0)
		return 0;
	if (v == t)
		return push;
	for (int &i = pts[v]; i < e[v].size(); i++)
	{
		int to = e[v][i].to;
		if (d[to] != d[v] + 1) continue;
		int pushed = dfs(to, min(push, e[v][i].cap - e[v][i].flow));
		if (pushed)
		{
			e[v][i].flow += pushed;
			e[to][e[v][i].rev].flow -= pushed;
			return pushed;
		}
	}
	return 0;
}

int dinic()
{
	int res = 0;
	while (bfs())
	{
		fill(pts, pts + N, 0);
		int pushed = 0;
		while (pushed = dfs(s, 1e9))
			res += pushed;
	}
	return res;
}

int n;

int input[N][N];
int fixd[N][N];
int gr[N][N];

int main()
{
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);

	cin >> n;
	for (int i = 0; i < n; ++i)
	{
		for (int j = 0; j < n; ++j)
		{
			cin >> input[i][j];
		}
	}

	bool checked[N];
	ZERO(checked);
	int c = 0;
	while (true)
	{
		checked[c] = true;
		for (int i = 1; i < n; ++i)
		{
			if (input[c][i] > 0)
			{
				checked[i] = true;
			}
			gr[c][i] = input[c][i];
			gr[i][c] = input[c][i];
		}

		c = -1;
		for (int i = 0; i < n; ++i)
		{
			if (!checked[i])
			{
				c = i;
				break;
			}
		}

		if (c == -1)
		{
			break;
		}
	}

	for (int i = 0; i < n; ++i)
	{
		for (int j = i+1; j < n; ++j)
		{
			for (int q = 0; q < N; ++q)
			{
				e[q].clear();
			}
			add_edge(s, i+1, INT_MAX);
			add_edge(j+1, t, INT_MAX);
			for (int ii = 0; ii < n; ++ii)
			{
				for (int jj = 0; jj < n; ++jj)
				{
					if (gr[ii][jj] > 0)
					{
						add_edge(ii+1, jj+1, gr[ii][jj]);
					}
				}
			}
			int fl = dinic();
			if (input[i][j] != fl)
			{
				cout << "NO";
				return 0;
			}
		}
	}

	cout << "YES" << endl;
	int edg = 0;
	for (int i = 0; i < n; ++i)
	{
		for (int j = i+1; j < n; ++j)
		{
			if (gr[i][j] > 0)
			{
				++edg;
			}
		}
	}

	cout << edg << endl;

	for (int i = 0; i < n; ++i)
	{
		for (int j = i+1; j < n; ++j)
		{
			if (gr[i][j] > 0)
			{
				cout << i+1 << " " << j+1 << " " << gr[i][j] << endl;
			}
		}
	}

	return 0;
}